/////////////////////////////////////////////////////////////
// CINEMA SDK : MATERIALS      														 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_MATERIALPLUGIN_H
#define __C4D_MATERIALPLUGIN_H

#include "ge_math.h"
#include "c4d_materialdata.h"
#include "c4d_nodeplugin.h"

struct MATERIALPLUGIN : public NODEPLUGIN
{
	Bool	(MaterialData::*Draw						)(PluginMaterial *mat, BaseObject *op, BaseTag *tag, BaseDraw *bd, BaseDrawHelp *bh);

	LONG  (MaterialData::*GetRenderInfo		)(PluginMaterial *mat);
	LONG  (MaterialData::*InitRender			)(PluginMaterial *mat, InitRenderStruct *irs);
	void	(MaterialData::*FreeRender		  )(PluginMaterial *mat);
	void  (MaterialData::*InitCalculation )(PluginMaterial *mat, VolumeData *vd, LONG type);
	void  (MaterialData::*Displace				)(PluginMaterial *mat, VolumeData *vd);
	void  (MaterialData::*ChangeNormal		)(PluginMaterial *mat, VolumeData *vd);
	void  (MaterialData::*CalcSurface			)(PluginMaterial *mat, VolumeData *vd);
	void  (MaterialData::*CalcTransparency)(PluginMaterial *mat, VolumeData *vd);
	void  (MaterialData::*CalcAlpha       )(PluginMaterial *mat, VolumeData *vd);
	void  (MaterialData::*CalcVolumetric	)(PluginMaterial *mat, VolumeData *vd);

	void*	reserved[(32-11)*C4DPL_MEMBERMULTIPLIER-0];
};

#endif

